Ext.define('Ext.data.Cors', {
    
    extend: 'Ext.data.Connection',
    
    alternateClassName: ['Ext.Cors'],
    
    singleton: true,
    
    useDefaultXhrHeader: false,
    
    autoAbort: false
    
});

Ext.define('Ext.data.proxy.Cors', {
    
    extend: 'Ext.data.proxy.Ajax',
    
    uses: ['Ext.data.Cors'],
    
    alias: 'proxy.cors',
    
    alternateClassName: ['Ext.data.CorsProxy'],
    
    actionMethods:{
        create :'POST',
        read   :'GET',
        update :'POST',
        destroy:'DELETE'
    },
    
    doRequest: function(operation, callback, scope) {
        var writer  = this.getWriter(),
            request = this.buildRequest(operation, callback, scope);
            
        if (operation.allowWrite()) {
            request = writer.write(request);
        }
        
        Ext.apply(request, {
            headers       : this.headers,
            timeout       : this.timeout,
            scope         : this,
            callback      : this.createRequestCallback(request, operation, callback, scope),
            method        : this.getMethod(request),
            disableCaching: false // explicitly set it to false, ServerProxy handles caching
        });
        
        Ext.Cors.request(request);
        
        return request;
    }


});

Ext.define('Override.app.Model', {
    override: 'Ext.data.Model',
    requires: ['Ext.data.proxy.Cors']
});